/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.objects.entity.EntitiesTFC;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public abstract class EntityAnimalMammal
extends EntityAnimalTFC {
    private static final DataParameter<Long> PREGNANT_TIME = EntityDataManager.func_187226_a(EntityAnimalMammal.class, EntitiesTFC.getLongDataSerializer());

    public EntityAnimalMammal(World worldIn) {
        super(worldIn);
    }

    public EntityAnimalMammal(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.setPregnantTime(-1L);
    }

    public long getPregnantTime() {
        return (Long)this.field_70180_af.func_187225_a(PREGNANT_TIME);
    }

    private void setPregnantTime(long day) {
        this.field_70180_af.func_187227_b(PREGNANT_TIME, (Object)day);
    }

    @Override
    public void onFertilized(IAnimalTFC male) {
        this.setPregnantTime(CalendarTFC.PLAYER_TIME.getTotalDays());
    }

    @Override
    public IAnimalTFC.Type getType() {
        return IAnimalTFC.Type.MAMMAL;
    }

    public abstract void birthChildren();

    public abstract long gestationDays();

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PREGNANT_TIME, (Object)-1L);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isFertilized() && CalendarTFC.PLAYER_TIME.getTotalDays() >= this.getPregnantTime() + this.gestationDays()) {
            this.birthChildren();
            this.setFertilized(false);
        }
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74772_a("pregnant", this.getPregnantTime());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setPregnantTime(nbt.func_74763_f("pregnant"));
    }
}

